/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.ui.editors;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableColumn;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.managers.EnumValueManager;
import org.jkiss.utils.CommonUtils;

public class MySQLEnumValueManager
extends EnumValueManager {
    protected boolean isMultiValue(IValueController valueController) {
        return valueController.getValueType().getTypeName().equalsIgnoreCase("set");
    }

    protected List<String> getEnumValues(IValueController valueController) {
        DBSTypedObject valueType = valueController.getValueType();
        if (valueType instanceof MySQLTableColumn) {
            return ((MySQLTableColumn)valueType).getEnumValues();
        }
        return null;
    }

    protected List<String> getSetValues(IValueController valueController, Object value) {
        String setString = DBValueFormatting.getDefaultValueDisplayString((Object)value, (DBDDisplayFormat)DBDDisplayFormat.UI);
        ArrayList<String> setValues = new ArrayList<String>();
        if (!CommonUtils.isEmpty((String)setString)) {
            StringTokenizer st = new StringTokenizer(setString, ",");
            while (st.hasMoreTokens()) {
                setValues.add(st.nextToken());
            }
        }
        return setValues;
    }
}

