/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ide.impl.wsl.ijent.nio;

import com.intellij.platform.ide.impl.wsl.ijent.nio.IjentWslNioFileSystemProvider;
import com.intellij.platform.ide.impl.wsl.ijent.nio.IjentWslNioPath;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B)\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0001\u0012\u0006\u0010\u0007\u001a\u00020\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\f\u001a\u00020\u0005H\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0005H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0014H\u0016J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u0019H\u0016J)\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u00052\u0012\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u001d\"\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u0012\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0005H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020%H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/platform/ide/impl/wsl/ijent/nio/IjentWslNioFileSystem;", "Ljava/nio/file/FileSystem;", "provider", "Lcom/intellij/platform/ide/impl/wsl/ijent/nio/IjentWslNioFileSystemProvider;", "wslId", "", "ijentFs", "originalFs", "<init>", "(Lcom/intellij/platform/ide/impl/wsl/ijent/nio/IjentWslNioFileSystemProvider;Ljava/lang/String;Ljava/nio/file/FileSystem;Ljava/nio/file/FileSystem;)V", "getWslId$intellij_platform_ide_impl_wsl", "()Ljava/lang/String;", "toString", "close", "", "isOpen", "", "isReadOnly", "getSeparator", "getRootDirectories", "", "Ljava/nio/file/Path;", "getFileStores", "Ljava/nio/file/FileStore;", "supportedFileAttributeViews", "", "getPath", "first", "more", "", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/nio/file/Path;", "getPathMatcher", "Ljava/nio/file/PathMatcher;", "syntaxAndPattern", "getUserPrincipalLookupService", "Ljava/nio/file/attribute/UserPrincipalLookupService;", "newWatchService", "Ljava/nio/file/WatchService;", "intellij.platform.ide.impl.wsl"})
@ApiStatus.Internal
public final class IjentWslNioFileSystem
extends FileSystem {
    @NotNull
    private final IjentWslNioFileSystemProvider provider;
    @NotNull
    private final String wslId;
    @NotNull
    private final FileSystem ijentFs;
    @NotNull
    private final FileSystem originalFs;

    public IjentWslNioFileSystem(@NotNull IjentWslNioFileSystemProvider provider, @NotNull String wslId, @NotNull FileSystem ijentFs, @NotNull FileSystem originalFs) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)wslId, (String)"wslId");
        Intrinsics.checkNotNullParameter((Object)ijentFs, (String)"ijentFs");
        Intrinsics.checkNotNullParameter((Object)originalFs, (String)"originalFs");
        this.provider = provider;
        this.wslId = wslId;
        this.ijentFs = ijentFs;
        this.originalFs = originalFs;
    }

    @NotNull
    public final String getWslId$intellij_platform_ide_impl_wsl() {
        return this.wslId;
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.provider + ")";
    }

    @Override
    public void close() {
        this.provider.removeFileSystem$intellij_platform_ide_impl_wsl(this.wslId);
        this.ijentFs.close();
    }

    @Override
    @NotNull
    public IjentWslNioFileSystemProvider provider() {
        return this.provider;
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    @NotNull
    public String getSeparator() {
        String string = this.originalFs.getSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSeparator(...)");
        return string;
    }

    @Override
    @NotNull
    public Iterable<Path> getRootDirectories() {
        Iterable<Path> iterable = this.originalFs.getRootDirectories();
        Intrinsics.checkNotNullExpressionValue(iterable, (String)"getRootDirectories(...)");
        return iterable;
    }

    @Override
    @NotNull
    public Iterable<FileStore> getFileStores() {
        Iterable<FileStore> iterable = this.originalFs.getFileStores();
        Intrinsics.checkNotNullExpressionValue(iterable, (String)"getFileStores(...)");
        Iterable<FileStore> iterable2 = this.ijentFs.getFileStores();
        Intrinsics.checkNotNullExpressionValue(iterable2, (String)"getFileStores(...)");
        return CollectionsKt.plus(iterable, iterable2);
    }

    @Override
    @NotNull
    public Set<String> supportedFileAttributeViews() {
        LinkedHashSet linkedHashSet;
        LinkedHashSet $this$supportedFileAttributeViews_u24lambda_u240 = linkedHashSet = new LinkedHashSet();
        boolean bl = false;
        $this$supportedFileAttributeViews_u24lambda_u240.addAll(this.originalFs.supportedFileAttributeViews());
        $this$supportedFileAttributeViews_u24lambda_u240.addAll(this.ijentFs.supportedFileAttributeViews());
        return linkedHashSet;
    }

    @Override
    @NotNull
    public Path getPath(@NotNull String first, String ... more) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)more, (String)"more");
        Path path = this.originalFs.getPath(first, Arrays.copyOf(more, more.length));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
        return new IjentWslNioPath(this, path, null);
    }

    @Override
    @NotNull
    public PathMatcher getPathMatcher(@Nullable String syntaxAndPattern) {
        PathMatcher pathMatcher = this.originalFs.getPathMatcher(syntaxAndPattern);
        Intrinsics.checkNotNullExpressionValue((Object)pathMatcher, (String)"getPathMatcher(...)");
        return pathMatcher;
    }

    @Override
    @NotNull
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        UserPrincipalLookupService userPrincipalLookupService = this.originalFs.getUserPrincipalLookupService();
        Intrinsics.checkNotNullExpressionValue((Object)userPrincipalLookupService, (String)"getUserPrincipalLookupService(...)");
        return userPrincipalLookupService;
    }

    @Override
    @NotNull
    public WatchService newWatchService() {
        WatchService watchService = this.originalFs.newWatchService();
        Intrinsics.checkNotNullExpressionValue((Object)watchService, (String)"newWatchService(...)");
        return watchService;
    }
}

