/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.remote.jdbc.LobInfo;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.GridEditGuard;
import com.intellij.database.run.ui.grid.editors.BoundaryValueResolver;
import com.intellij.database.run.ui.grid.editors.UnparsedValue;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface GridCellEditorHelper {
    public static final Key<GridCellEditorHelper> GRID_CELL_EDITOR_HELPER_KEY = new Key("GRID_CELL_EDITOR_HELPER_KEY");

    @NotNull
    public UnparsedValue createUnparsedValue(@NotNull String var1, @Nullable UnparsedValue.ParsingError var2, @NotNull CoreGrid<GridRow, GridColumn> var3, @NotNull ModelIndex<GridRow> var4, @NotNull ModelIndex<GridColumn> var5);

    public EnumSet<ReservedCellValue> getSpecialValues(@NotNull CoreGrid<GridRow, GridColumn> var1, @NotNull ModelIndex<GridColumn> var2);

    public boolean isNullable(@NotNull CoreGrid<GridRow, GridColumn> var1, @NotNull ModelIndex<GridColumn> var2);

    @NotNull
    public List<String> getEnumValues(@NotNull CoreGrid<GridRow, GridColumn> var1, ModelIndex<GridColumn> var2);

    @NotNull
    public BoundaryValueResolver getResolver(@NotNull CoreGrid<GridRow, GridColumn> var1, @Nullable ModelIndex<GridColumn> var2);

    public boolean useBigDecimalWithPriorityType(@NotNull CoreGrid<GridRow, GridColumn> var1);

    public boolean parseBigIntAsLong(@NotNull CoreGrid<GridRow, GridColumn> var1);

    public boolean useLenientFormatterForTemporalObjects(@NotNull CoreGrid<GridRow, GridColumn> var1);

    @Nls
    @NotNull
    public String getDateFormatSuffix(@NotNull CoreGrid<GridRow, GridColumn> var1, @NotNull ModelIndex<GridColumn> var2);

    public static boolean areValuesEqual(Object v1, Object v2) {
        return GridCellEditorHelper.areValuesEqual(v1, v2, GridCellEditorHelper::numberEquals);
    }

    public static boolean areValuesEqual(Object v1, Object v2, @NotNull BiFunction<Object, Object, ThreeState> numberEquals) {
        ThreeState result;
        if (numberEquals == null) {
            GridCellEditorHelper.$$$reportNull$$$0(0);
        }
        if (v1 == ReservedCellValue.NULL) {
            v1 = null;
        }
        if (v2 == ReservedCellValue.NULL) {
            v2 = null;
        }
        if ((result = GridCellEditorHelper.simpleEquals(v1, v2)) == ThreeState.UNSURE) {
            result = numberEquals.apply(v1, v2);
        }
        if (result == ThreeState.UNSURE) {
            result = GridCellEditorHelper.arrayEquals(v1, v2);
        }
        if (result == ThreeState.UNSURE) {
            result = GridCellEditorHelper.clobEquals(v1, v2);
        }
        if (result == ThreeState.UNSURE) {
            result = ThreeState.NO;
        }
        return result.toBoolean();
    }

    public static ThreeState simpleEquals(Object v1, Object v2) {
        return Comparing.equal((Object)v1, (Object)v2) ? ThreeState.YES : ThreeState.UNSURE;
    }

    public static ThreeState arrayEquals(Object v1, Object v2) {
        if (v1 != null && v2 != null && v1.getClass() == v2.getClass() && v1.getClass().isArray()) {
            if (v1 instanceof byte[]) {
                return ThreeState.fromBoolean((boolean)Arrays.equals((byte[])v1, (byte[])v2));
            }
            if (v1 instanceof char[]) {
                return ThreeState.fromBoolean((boolean)Arrays.equals((char[])v1, (char[])v2));
            }
        }
        return ThreeState.UNSURE;
    }

    public static ThreeState clobEquals(Object v1, Object v2) {
        LobInfo.ClobInfo info1 = (LobInfo.ClobInfo)ObjectUtils.tryCast((Object)v1, LobInfo.ClobInfo.class);
        LobInfo.ClobInfo info2 = (LobInfo.ClobInfo)ObjectUtils.tryCast((Object)v2, LobInfo.ClobInfo.class);
        if (info1 != null && info2 != null) {
            return ThreeState.fromBoolean((!info2.isTruncated() && GridCellEditorHelper.clobStringEquals(info1, info2.data) ? 1 : 0) != 0);
        }
        if (info1 != null && v2 instanceof String) {
            return ThreeState.fromBoolean((boolean)GridCellEditorHelper.clobStringEquals(info1, (String)v2));
        }
        if (info2 != null && v1 instanceof String) {
            return ThreeState.fromBoolean((boolean)GridCellEditorHelper.clobStringEquals(info2, (String)v1));
        }
        return ThreeState.UNSURE;
    }

    public static boolean clobStringEquals(@NotNull LobInfo.ClobInfo lob, @Nullable String s) {
        if (lob == null) {
            GridCellEditorHelper.$$$reportNull$$$0(1);
        }
        return !lob.isTruncated() && Objects.equals(lob.data, s);
    }

    public static ThreeState numberEquals(Object v1, Object v2) {
        Number n1 = (Number)ObjectUtils.tryCast((Object)v1, Number.class);
        Number n2 = (Number)ObjectUtils.tryCast((Object)v2, Number.class);
        if (n1 != null && n2 != null) {
            long l1 = n1.longValue();
            long l2 = n2.longValue();
            double d1 = n1.doubleValue();
            double d2 = n2.doubleValue();
            return ThreeState.fromBoolean((l1 == l2 && (d1 == d2 || Double.isNaN(d1) && Double.isNaN(d2)) ? 1 : 0) != 0);
        }
        return ThreeState.UNSURE;
    }

    @Nullable
    public Set<GridEditGuard> getEditGuards();

    @NotNull
    public static GridCellEditorHelper get(@NotNull CoreGrid<?, ?> grid) {
        if (grid == null) {
            GridCellEditorHelper.$$$reportNull$$$0(2);
        }
        GridCellEditorHelper gridCellEditorHelper = Objects.requireNonNull((GridCellEditorHelper)GRID_CELL_EDITOR_HELPER_KEY.get(grid));
        if (gridCellEditorHelper == null) {
            GridCellEditorHelper.$$$reportNull$$$0(3);
        }
        return gridCellEditorHelper;
    }

    public static void set(@NotNull CoreGrid<?, ?> grid, @NotNull GridCellEditorHelper helper) {
        if (grid == null) {
            GridCellEditorHelper.$$$reportNull$$$0(4);
        }
        if (helper == null) {
            GridCellEditorHelper.$$$reportNull$$$0(5);
        }
        GRID_CELL_EDITOR_HELPER_KEY.set(grid, (Object)helper);
    }

    public int guessJdbcTypeForEditing(@NotNull CoreGrid<GridRow, GridColumn> var1, @Nullable ModelIndex<GridRow> var2, @NotNull ModelIndex<GridColumn> var3);

    public boolean areValuesEqual(Object var1, Object var2, @Nullable CoreGrid<GridRow, GridColumn> var3);

    @Nullable
    public ReservedCellValue getDefaultNullValue(@NotNull CoreGrid<GridRow, GridColumn> var1, @Nullable ModelIndex<GridColumn> var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "numberEquals";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lob";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/editors/GridCellEditorHelper";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/editors/GridCellEditorHelper";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "areValuesEqual";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "clobStringEquals";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "set";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

