/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.intrinsics;

import com.intellij.psi.tree.IElementType;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.jvm.codegen.ClassCodegen;
import org.jetbrains.kotlin.backend.jvm.intrinsics.CallBasedIntrinsicMethod;
import org.jetbrains.kotlin.backend.jvm.intrinsics.Ieee754Equals;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IntrinsicFunction;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.NumberComparisonUtils;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\f\u0010\u0011\u001a\u00020\u0012*\u00020\u0013H\u0002J\f\u0010\u0014\u001a\u00020\u0012*\u00020\u0013H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/Ieee754Equals;", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/CallBasedIntrinsicMethod;", "operandType", "Lorg/jetbrains/org/objectweb/asm/Type;", "<init>", "(Lorg/jetbrains/org/objectweb/asm/Type;)V", "getOperandType", "()Lorg/jetbrains/org/objectweb/asm/Type;", "boxedOperandType", "toCallable", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IntrinsicFunction;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "signature", "Lorg/jetbrains/kotlin/resolve/jvm/jvmSignature/JvmMethodSignature;", "classCodegen", "Lorg/jetbrains/kotlin/backend/jvm/codegen/ClassCodegen;", "upperBoundedByPrimitiveNumberOrNullableType", "", "Lorg/jetbrains/kotlin/ir/types/IrType;", "isPrimitiveNumberOrNullableType", "backend.jvm.codegen"})
@SourceDebugExtension(value={"SMAP\nEquals.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Equals.kt\norg/jetbrains/kotlin/backend/jvm/intrinsics/Ieee754Equals\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,248:1\n1807#2,3:249\n*S KotlinDebug\n*F\n+ 1 Equals.kt\norg/jetbrains/kotlin/backend/jvm/intrinsics/Ieee754Equals\n*L\n239#1:249,3\n*E\n"})
public final class Ieee754Equals
extends CallBasedIntrinsicMethod {
    @NotNull
    private final Type operandType;
    @NotNull
    private final Type boxedOperandType;

    public Ieee754Equals(@NotNull Type operandType) {
        Intrinsics.checkNotNullParameter((Object)operandType, (String)"operandType");
        this.operandType = operandType;
        Type type = AsmUtil.boxType(this.operandType);
        Intrinsics.checkNotNullExpressionValue((Object)type, (String)"boxType(...)");
        this.boxedOperandType = type;
    }

    @NotNull
    public final Type getOperandType() {
        return this.operandType;
    }

    @Override
    @NotNull
    public IntrinsicFunction toCallable(@NotNull IrFunctionAccessExpression expression2, @NotNull JvmMethodSignature signature, @NotNull ClassCodegen classCodegen) {
        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u000e"}, d2={"org/jetbrains/kotlin/backend/jvm/intrinsics/Ieee754Equals$toCallable$Ieee754AreEqual", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IntrinsicFunction;", "left", "Lorg/jetbrains/org/objectweb/asm/Type;", "right", "<init>", "(Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;Lorg/jetbrains/kotlin/resolve/jvm/jvmSignature/JvmMethodSignature;Lorg/jetbrains/kotlin/backend/jvm/codegen/ClassCodegen;Lorg/jetbrains/org/objectweb/asm/Type;Lorg/jetbrains/org/objectweb/asm/Type;)V", "getLeft", "()Lorg/jetbrains/org/objectweb/asm/Type;", "getRight", "genInvokeInstruction", "", "v", "Lorg/jetbrains/org/objectweb/asm/commons/InstructionAdapter;", "backend.jvm.codegen"})
        public final class Ieee754AreEqual
        extends IntrinsicFunction {
            private final Type left;
            private final Type right;

            public Ieee754AreEqual(IrFunctionAccessExpression $expression, JvmMethodSignature $signature, ClassCodegen $classCodegen, Type left, Type right) {
                Intrinsics.checkNotNullParameter((Object)left, (String)"left");
                Intrinsics.checkNotNullParameter((Object)right, (String)"right");
                Object[] objectArray = new Type[]{left, right};
                super($expression, $signature, $classCodegen, CollectionsKt.listOf((Object[])objectArray));
                this.left = left;
                this.right = right;
            }

            public final Type getLeft() {
                return this.left;
            }

            public final Type getRight() {
                return this.right;
            }

            public void genInvokeInstruction(InstructionAdapter v) {
                Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                Type[] typeArray = new Type[]{this.left, this.right};
                v.invokestatic("kotlin/jvm/internal/Intrinsics", "areEqual", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])typeArray), false);
            }
        }
        IntrinsicFunction intrinsicFunction;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        Intrinsics.checkNotNullParameter((Object)classCodegen, (String)"classCodegen");
        Object object = expression2.getArguments().get(0);
        Intrinsics.checkNotNull((Object)object);
        IrExpression arg0 = (IrExpression)object;
        Object object2 = expression2.getArguments().get(1);
        Intrinsics.checkNotNull((Object)object2);
        IrExpression arg1 = (IrExpression)object2;
        if (!this.isPrimitiveNumberOrNullableType(arg0.getType()) && !this.upperBoundedByPrimitiveNumberOrNullableType(arg0.getType())) {
            throw new AssertionError((Object)("Should be primitive or nullable primitive type: " + arg0.getType()));
        }
        if (!this.isPrimitiveNumberOrNullableType(arg1.getType()) && !this.upperBoundedByPrimitiveNumberOrNullableType(arg1.getType())) {
            throw new AssertionError((Object)("Should be primitive or nullable primitive type: " + arg1.getType()));
        }
        boolean arg0isNullable = IrTypeUtilsKt.isNullable((IrType)arg0.getType());
        boolean arg1isNullable = IrTypeUtilsKt.isNullable((IrType)arg1.getType());
        boolean useNonIEEE754Comparison = !classCodegen.getContext().getConfig().getLanguageVersionSettings().supportsFeature(LanguageFeature.ProperIeee754Comparisons) && (JvmIrUtilsKt.isSmartcastFromHigherThanNullable(arg0, classCodegen.getContext()) || JvmIrUtilsKt.isSmartcastFromHigherThanNullable(arg1, classCodegen.getContext()));
        if (useNonIEEE754Comparison) {
            Type type = AsmTypes.OBJECT_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"OBJECT_TYPE");
            Type type2 = AsmTypes.OBJECT_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"OBJECT_TYPE");
            intrinsicFunction = new Ieee754AreEqual(expression2, signature, classCodegen, type, type2);
        } else {
            @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0019\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"org/jetbrains/kotlin/backend/jvm/intrinsics/Ieee754Equals$toCallable$Ieee754Primitives", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IntrinsicFunction;", "<init>", "(Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;Lorg/jetbrains/kotlin/resolve/jvm/jvmSignature/JvmMethodSignature;Lorg/jetbrains/kotlin/backend/jvm/codegen/ClassCodegen;Lorg/jetbrains/kotlin/backend/jvm/intrinsics/Ieee754Equals;)V", "genInvokeInstruction", "", "v", "Lorg/jetbrains/org/objectweb/asm/commons/InstructionAdapter;", "backend.jvm.codegen"})
            public final class Ieee754Primitives
            extends IntrinsicFunction {
                final /* synthetic */ Ieee754Equals this$0;

                public Ieee754Primitives(IrFunctionAccessExpression $expression, JvmMethodSignature $signature, ClassCodegen $classCodegen, Ieee754Equals $receiver) {
                    this.this$0 = $receiver;
                    Object[] objectArray = new Type[]{$receiver.getOperandType(), $receiver.getOperandType()};
                    super($expression, $signature, $classCodegen, CollectionsKt.listOf((Object[])objectArray));
                }

                public void genInvokeInstruction(InstructionAdapter v) {
                    Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                    KtSingleValueToken ktSingleValueToken = KtTokens.EQEQ;
                    Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"EQEQ");
                    int opcode = NumberComparisonUtils.INSTANCE.getNumberCompareOpcode((IElementType)ktSingleValueToken);
                    Label branchJumpLabel = new Label();
                    KtSingleValueToken ktSingleValueToken2 = KtTokens.EQEQ;
                    Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken2, (String)"EQEQ");
                    v.visitJumpInsn(NumberComparisonUtils.INSTANCE.patchOpcode(opcode, v, (IElementType)ktSingleValueToken2, this.this$0.getOperandType()), branchJumpLabel);
                    Label endLabel = new Label();
                    v.iconst(1);
                    v.goTo(endLabel);
                    v.visitLabel(branchJumpLabel);
                    v.iconst(0);
                    v.visitLabel(endLabel);
                }
            }
            intrinsicFunction = !arg0isNullable && !arg1isNullable ? (IntrinsicFunction)new Ieee754Primitives(expression2, signature, classCodegen, this) : (arg0isNullable && !arg1isNullable ? (IntrinsicFunction)new Ieee754AreEqual(expression2, signature, classCodegen, this.boxedOperandType, this.operandType) : (!arg0isNullable && arg1isNullable ? (IntrinsicFunction)new Ieee754AreEqual(expression2, signature, classCodegen, this.operandType, this.boxedOperandType) : (IntrinsicFunction)new Ieee754AreEqual(expression2, signature, classCodegen, this.boxedOperandType, this.boxedOperandType)));
        }
        return intrinsicFunction;
    }

    private final boolean upperBoundedByPrimitiveNumberOrNullableType(IrType $this$upperBoundedByPrimitiveNumberOrNullableType) {
        boolean bl;
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull((IrType)$this$upperBoundedByPrimitiveNumberOrNullableType);
        Object object = irClassifierSymbol instanceof IrTypeParameterSymbol ? (IrTypeParameterSymbol)irClassifierSymbol : null;
        if (object != null && (object = (IrTypeParameter)object.getOwner()) != null && (object = object.getSuperTypes()) != null) {
            boolean bl2;
            block5: {
                Iterable $this$any$iv = (Iterable)object;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        IrType it = (IrType)element$iv;
                        boolean bl3 = false;
                        if (!(this.isPrimitiveNumberOrNullableType(it) || this.upperBoundedByPrimitiveNumberOrNullableType(it))) continue;
                        bl2 = true;
                        break block5;
                    }
                    bl2 = false;
                }
            }
            bl = bl2;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isPrimitiveNumberOrNullableType(IrType $this$isPrimitiveNumberOrNullableType) {
        PrimitiveType primitiveType = IrTypePredicatesKt.getPrimitiveType((IrType)$this$isPrimitiveNumberOrNullableType);
        return primitiveType != null && primitiveType != PrimitiveType.BOOLEAN && primitiveType != PrimitiveType.CHAR;
    }
}

