/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.awt.Component;
import org.assertj.core.description.Description;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.Strings;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.edt.GuiLazyLoadingDescription;
import org.assertj.swing.format.Formatting;
import org.assertj.swing.query.ComponentEnabledQuery;
import org.assertj.swing.timing.Condition;

class ComponentEnabledCondition
extends Condition {
    private Component c;

    @Nonnull
    static ComponentEnabledCondition untilIsEnabled(@Nonnull Component c) {
        return new ComponentEnabledCondition(c);
    }

    private ComponentEnabledCondition(@Nonnull Component c) {
        super(ComponentEnabledCondition.description(c));
        this.c = c;
    }

    @Nonnull
    private static Description description(final @Nonnull Component c) {
        return new GuiLazyLoadingDescription(){

            @Override
            @Nonnull
            protected String loadDescription() {
                return Strings.concat((Object[])new Object[]{Formatting.format(c), " to be enabled"});
            }
        };
    }

    @Override
    @RunsInEDT
    public boolean test() {
        return ComponentEnabledQuery.isEnabled((Component)Preconditions.checkNotNull((Object)this.c));
    }

    @Override
    protected void done() {
        this.c = null;
    }
}

