/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.assertj.core.util.Strings;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.driver.JTreeChildOfPathCountQuery;
import org.assertj.swing.timing.Condition;

class JTreeChildrenShowUpCondition
extends Condition {
    private JTree tree;
    private TreePath path;

    @Nonnull
    static JTreeChildrenShowUpCondition untilChildrenShowUp(@Nonnull JTree tree, @Nonnull TreePath path) {
        return new JTreeChildrenShowUpCondition(tree, path);
    }

    private JTreeChildrenShowUpCondition(@Nonnull JTree tree, @Nonnull TreePath path) {
        super(Strings.concat((Object[])new Object[]{path.toString(), " to show"}));
        this.tree = tree;
        this.path = path;
    }

    @Override
    @RunsInEDT
    public boolean test() {
        return JTreeChildOfPathCountQuery.childCount(this.tree, this.path) != 0;
    }

    @Override
    protected void done() {
        this.tree = null;
        this.path = null;
    }
}

