/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.serialize;

import java.io.Serializable;
import org.gradle.api.JavaVersion;

public class StackTraceElementPlaceholder
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String classLoaderName;
    private final String moduleName;
    private final String moduleVersion;
    private final String declaringClass;
    private final String methodName;
    private final String fileName;
    private final int lineNumber;

    public StackTraceElementPlaceholder(StackTraceElement ste) {
        if (JavaVersion.current().isJava9Compatible()) {
            this.classLoaderName = ste.getClassLoaderName();
            this.moduleName = ste.getModuleName();
            this.moduleVersion = ste.getModuleVersion();
        } else {
            this.classLoaderName = null;
            this.moduleName = null;
            this.moduleVersion = null;
        }
        this.declaringClass = ste.getClassName();
        this.methodName = ste.getMethodName();
        this.fileName = ste.getFileName();
        this.lineNumber = ste.getLineNumber();
    }

    public StackTraceElement toStackTraceElement() {
        if (JavaVersion.current().isJava9Compatible()) {
            return new StackTraceElement(this.classLoaderName, this.moduleName, this.moduleVersion, this.declaringClass, this.methodName, this.fileName, this.lineNumber);
        }
        return new StackTraceElement(this.declaringClass, this.methodName, this.fileName, this.lineNumber);
    }
}

